/*
 * @(#)ZipTable.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */

import java.io.File;
import java.lang.Object;

import java.util.Vector;
import java.util.Hashtable;

import java.awt.Component;
import java.awt.Color;
import java.awt.Font;

import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.ImageIcon;


/**
 * Class zip table extends JTable, but specialize it : the render (with icons, and selected color)
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipTable extends JTable {

    // private members
    private static ImageIcon defaultIcon = new ImageIcon("images" + File.separator + "small_unknow.gif");
    private static Hashtable iconTable = new Hashtable();
    private ImageIcon iconWork;
    private Font font;
    private Vector data;


    /**
     * Class constructor
     * @param dataTable the table (vector of vectors) where data are stored
     * @param nameColumn title of columns
     */
    public ZipTable(Vector dataTable, Vector nameColumn) {
	super(dataTable,nameColumn);

	// specialize the JTable
	data = dataTable;
	setHashtable();
	setDefaultRenderer(getColumnClass(0), new MyTableCellRenderer());
	setShowGrid(false);
	setAutoResizeMode(AUTO_RESIZE_ALL_COLUMNS);
	Font tmpfont = getFont();
	font = new Font(tmpfont.getName(), tmpfont.getStyle(), tmpfont.getSize() - 3);
    }


    /**
     * Return if the cell in row,col is editable
     * @param row the row of the cell
     * @param col the colomn of the cell
     * @return always false the table is not editable
     */
    public boolean isCellEditable(int row, int col) {
	return false;
    }


    /**
     * Class which define the renderer of the cell, implement TableCellRenderer
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    public class MyTableCellRenderer implements TableCellRenderer {


	/**
	 * Return the construct JLabel of the cell at position row, column
	 * @param table the JTable access
	 * @param value the value of the object
	 * @param isSelected true if the cell is selected
	 * @param hasFocus true if the cursor is on this cell
	 * @param row the row location of the cell in the JTable
	 * @param column the column location of the cell in the JTable
	 * @return the construct JKLabel, ready to display
	 */
	public Component getTableCellRendererComponent(JTable table, Object value,
						       boolean isSelected, boolean hasFocus,
						       int row, int column) {
	    // if is a cell (not a line of the table)
	    if(value != null) {
		JLabel j = new JLabel();
		j.setText(value.toString());
		j.setFont(font);

		// put the icon at the first column associate with the file extension(col num 1)
		if(column == 0) {
		    iconWork = (ImageIcon)iconTable.get((String)((Vector)data.elementAt(row)).elementAt(1));
		    
		    j.setIcon((iconWork != null) ? iconWork : defaultIcon);
		    
		    j.setForeground(isSelected ? Color.blue : Color.gray);

		}
		else {
		    j.setForeground(Color.gray);
		    j.setHorizontalAlignment(JLabel.CENTER);
		}
		return j;
	    }
	    else {
		return null;
	    }
	}
    }


    /**
     * Set the global hashtable of ImageIcon indexed by the file extension
     */
    public void setHashtable() {
	iconTable.put("JAVA", new ImageIcon("images" + File.separator + "small_java.gif"));
	iconTable.put("CLASS", new ImageIcon("images" + File.separator + "small_class.gif"));
	iconTable.put("ZIP", new ImageIcon("images" + File.separator + "small_zip.gif"));
	iconTable.put("DOC", new ImageIcon("images" + File.separator + "small_word.gif"));
	iconTable.put("TXT", new ImageIcon("images" + File.separator + "small_texte.gif"));
	iconTable.put("DLL", new ImageIcon("images" + File.separator + "small_dll.gif"));
	iconTable.put("EXE", new ImageIcon("images" + File.separator + "small_executable.gif"));
	iconTable.put("COM", new ImageIcon("images" + File.separator + "small_executable.gif"));
	iconTable.put("GIF", new ImageIcon("images" + File.separator + "small_gif.gif"));
	iconTable.put("HLP", new ImageIcon("images" + File.separator + "small_help.gif"));
	iconTable.put("HTML", new ImageIcon("images" + File.separator + "small_html.gif"));
	iconTable.put("HTM", new ImageIcon("images" + File.separator + "small_html.gif"));
	iconTable.put("INI", new ImageIcon("images" + File.separator + "small_ini.gif"));
	iconTable.put("JPEG", new ImageIcon("images" + File.separator + "small_jpeg.gif"));
	iconTable.put("JPG", new ImageIcon("images" + File.separator + "small_jpeg.gif"));
	iconTable.put("BAT", new ImageIcon("images" + File.separator + "small_bat.gif"));
	iconTable.put("install",new ImageIcon("images" + File.separator + "small_install.gif"));
	iconTable.put("directory",new ImageIcon("images" + File.separator + "small_directory.gif"));
    }

}
